const express = require('express');
const fs = require('fs');
const path = require('path');
const bodyParser = require('body-parser');

const app = express();
const port = 3000;

app.use(bodyParser.json());
app.use(express.static('public')); // Assurez-vous que vos fichiers HTML et JS sont dans le répertoire 'public'

const filePath = path.join(__dirname, 'Seth.txt');

// Endpoint pour sauvegarder les coordonnées
app.post('/save-coordinates', (req, res) => {
    const { source, destination } = req.body;

    if (!source || !destination) {
        return res.status(400).send('Source et destination sont requis.');
    }

    const data = `Source: ${source.lat}, ${source.lng}\nDestination: ${destination.lat}, ${destination.lng}\n\n`;

    fs.appendFile(filePath, data, (err) => {
        if (err) {
            console.error('Erreur lors de l\'écriture dans le fichier:', err);
            return res.status(500).send('Échec de la sauvegarde des données.');
        }

        res.send('Données sauvegardées avec succès.');
    });
});

// Endpoint pour récupérer les coordonnées sauvegardées
app.get('/get-coordinates', (req, res) => {
    fs.readFile(filePath, 'utf8', (err, data) => {
        if (err) {
            console.error('Erreur lors de la lecture du fichier:', err);
            return res.status(500).send('Erreur lors de la lecture des données.');
        }

        res.send(data);
    });
});

app.listen(port, () => {
    console.log(`Serveur en écoute sur http://localhost:${port}`);
});
